package cn.com.duiba.tuia.core.api.dto.autoReflow;

import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
public class AutoReflowConfigDTO  extends BaseQueryReq implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "ID")
    protected Long id;

    @ApiModelProperty(value = "回流计划有效开始时间")
    private Date effectiveStartTime;

    @ApiModelProperty(value = "回流计划有效结束时间")
    private Date effectiveEndTime;

    @ApiModelProperty(value = "回流模式 1:点击模式 2:转化模式")
    private Integer reflowType;

    @ApiModelProperty(value = "外部媒体名称")
    private String externalAppName;

    @ApiModelProperty(value = "外部媒体账号ID,比如快手，巨量等")
    private String externalAccountId;

    @ApiModelProperty(value = "外部广告计划ID,逗号分隔的字符串")
    private String externalAdvertId;

    @ApiModelProperty(value = "推啊广告ID")
    private Long advertId;

    @ApiModelProperty(value = "推啊配置Id")
    private Long orientPackageId;

    @ApiModelProperty(value = "推啊广告名称")
    private String advertName;

    @ApiModelProperty(value = "推啊广告主ID")
    private Long accountId;

    @ApiModelProperty(value = "推啊广告主名称")
    private String accountName;

    @ApiModelProperty(value = "推啊媒体ID")
    private Long appId;

    @ApiModelProperty(value = "推啊媒体名称")
    private String appName;

    @ApiModelProperty(value = "推啊广告位ID")
    private Long slotId;

    @ApiModelProperty(value = "刷量比例")
    private Integer brushRation;

    @ApiModelProperty(value = "Ctr基准线")
    private Integer ctr;

    @ApiModelProperty(value = "计划开关状态 1:开 0:关闭")
    private Integer switchStatus;

    @ApiModelProperty(value = "是否删除 1:已删除 0:未删除")
    private Boolean isDeleted;

    @ApiModelProperty(value = "任务状态 1:刷量中 2:已暂停 3:回流结束 4:回流中止")
    private Integer planStatus;

    @ApiModelProperty(value = "异常原因")
    private String errorReason;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("更新时间")
    private Date gmtModified;

}
