package cn.com.duiba.tuia.core.api.dto.backflowManualRecord;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**

 */
@Getter
@Setter
public class BackflowManualRecordFormDTO implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "ID")
    protected Long id;

    @ApiModelProperty(value = "广告id")
    private Long advertId;

    @ApiModelProperty(value = "广告名称")
    private String advertName;

    @ApiModelProperty(value = "广告主id")
    private Long advertiserId;

    @ApiModelProperty(value = "广告主名称")
    private String advertiserName;

    @ApiModelProperty(value = "代理商id")
    private Long agentId;

    @ApiModelProperty(value = "配置id")
    private Long orientPackageId;

    @ApiModelProperty(value = "配置名称")
    private String orientPackageName;

    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "媒体名称")
    private String appName;

    @ApiModelProperty(value = "广告位id")
    private String slotId;

    @ApiModelProperty(value = "广告位名称")
    private String slotName;

    @ApiModelProperty(value = "消耗")
    private BigDecimal consumeAmount;

    @ApiModelProperty(value = "回流时间")
    private Date reflowDate;

    @ApiModelProperty(value = "回流模式  1.点击模式 2.转化模式")
    private Integer reflowType;

    @ApiModelProperty(value = "回流状态  1.回流中 2.回流完成")
    private Integer reflowStatus;

    @ApiModelProperty(value = "曝光pv")
    private Long exposurePv;

    @ApiModelProperty(value = "点击pv")
    private Long clickPv;

    @ApiModelProperty(value = "点击率")
    private BigDecimal ctr;

    @ApiModelProperty(value = "转化pv")
    private Long converPv;

    @ApiModelProperty(value = "创建人名称")
    private String creator;


    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty(value = "总消耗")
    private BigDecimal totalConsume;

    @ApiModelProperty(value = "消耗主体类型")
    private Integer effectiveMainType;

    @ApiModelProperty(value = "资源标签")
    private String resourceTag;
}