package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertiserCheckAdvertDTO;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertiserCheckAdvertQueryDTO;
import cn.com.duiba.tuia.core.api.dto.req.OperationLog;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdvertiserAuditPromoteService {
    /**
     * 主链接送审接口 (主链接->广告审核)
     */
    Integer submitMainPromoteForReview(Long advertId,String promoteUrl);


    /**
     * 其他落地页链接送审接口（落地页审核、百奇）
     */
    Integer submitPromoteForReview(Long advertId,Long promoteUrlId,String promoteUrl);


    /**
     * 落地页审核分页查询
     */
    PageDto<AdvertiserCheckAdvertDTO> searchReviewPromotes(AdvertiserCheckAdvertQueryDTO advertiserCheckAdvertQueryDTO);

    /**
     * 清理数据
     * @param advertId
     * @param promoteUrlId
     */
    void clearData(Long advertId, Long promoteUrlId);

    /**
     * 审核通过
     */
    Integer auditPass(Long auditId, OperationLog operationLog);

    /**
     * 审核拒绝
     */
    Integer auditRejection(Long auditId,OperationLog operationLog);

    List<AdvertiserCheckAdvertDTO> selectListByAdverIdtList(List<Long> advertIdList);

}
