package cn.com.duiba.tuia.core.api.remoteservice.compensate;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.compensate.CompensateDetailDTO;
import cn.com.duiba.tuia.core.api.dto.compensate.CompensateDetailQueryDTO;
import cn.com.duiba.tuia.core.api.dto.compensate.CompensateWithdrawDTO;

/**
 * 赔付详情Remote接口
 *
 * @author zhangbaiqiang
 * @date 2021/4/29
 */
@AdvancedFeignClient
public interface RemoteCompensateDetailService {

    /**
     * 分页查询赔付详情
     */
    PageDto<CompensateDetailDTO> pagingList(CompensateDetailQueryDTO pagingParam);

    /**
     * 查询广告主的待赔付金额
     *
     * @param accountId 广告主Id
     * @return 待赔付金额（分）
     */
    Long queryReadyCompensateAmount(Long accountId);

    /**
     * 申请提现
     *
     * @param param 请求参数
     * @return 是否成功
     */
    boolean withdrawApply(CompensateWithdrawDTO param) throws BizException;

    /**
     * 查询广告主的返货赔付使用状态
     *
     * @param accountId 广告主Id
     * @return 返货赔付使用状态 {@link cn.com.duiba.tuia.core.api.enums.compensate.CashBackStateEnum}
     */
    Integer queryCashBackState(Long accountId);
}
