/**
 * 
 */
package cn.com.duiba.tuia.core.api.constant;
/*
 * @规范： http://cf.dui88.com/pages/viewpage.action?pageId=3544570
 * @汇总文档：http://cf.dui88.com/pages/viewpage.action?pageId=3560274
 */
public enum WechatErrorCode {
    /** 成功. */
    E0000000("0000000", "成功"),

    E9999999("9999999", "未知错误"),

    E0000001("0000001", "参数错误"),

    E0000002("0000002", "查询不到数据"),

    E0000003("0000003", "获取二维码失败"),

    E0000004("0000004", "不支持的第三方平台授权"),

    E0000005("0000005", "获取刷新令牌失败"),







    ;

    /** 错误码. */
    private String errorCode;//NOSONAR

    /** 中文描述. */
    private String desc;

    /**
     * The Constructor.
     *
     * @param errorCode the error code
     * @param desc the desc
     */
    private WechatErrorCode(String errorCode, String desc) {
        this.errorCode = "WC-" + errorCode;
        this.desc = desc;
    }

    /**
     * Gets the error code.
     *
     * @return the error code
     */
    public String getErrorCode() {
        return errorCode;
    }

    /**
     * Gets the desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }
}
