package cn.com.duiba.tuia.core.api.dto.advertZeroStart;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 广告冷启动计划表
 * @author chencheng
 * @since 2022-12-13
 */
@Getter
@Setter
public class AdvertZeroStartAbTestConfigQueryDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("广告id")
    private Long advertId;

    @ApiModelProperty("配置id")
    private Long orientPkgId;

    @ApiModelProperty("媒体id")
    private Long appId;

    @ApiModelProperty("优化目标")
    private Integer subType;

    @ApiModelProperty("测试状态：0-排队中，1-测试中，2-测试完成，3-已过期，4-人工暂停")
    private Integer planStatus;

    @ApiModelProperty("创建时间")
    private String gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("冷启动开始测试时间")
    private Date testStartTime;

    @ApiModelProperty("冷启动结束测试时间")
    private Date testEndTime;

    @ApiModelProperty("目标转化数")
    private Long targetTransformNum;

    @ApiModelProperty("新行业标签")
    private String newTrade;

    /**
     * 可以看到的广告ID
     */
    private List<Long> advertIds;
}
