package cn.com.duiba.tuia.core.api.dto.smallapp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 小程序游戏回传配置表
 * @author lijicong
 * @since 2022-05-05
 */
@Getter
@Setter
public class SmallappCallbackConfigFormDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("")
    private Long id;

    @ApiModelProperty("广告主ID")
    @NotNull(message = "必须填写广告id～")
    private Long advertiserId;

    @ApiModelProperty("渠道JL-巨量")
    @NotBlank
    private String channel;

    @ApiModelProperty("上报链接")
    @NotBlank(message = "必须填写上报URL～")
    private String reportUrl;

    @ApiModelProperty("密钥")
    @NotBlank(message = "必须填写密钥～")
    private String secretKey;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

}
