package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum DmpDataUpdatePeridEnum {
    EVERY_TIME(0L,0,"每次"),
    EVERY_DAY(86400000L,1,"每日"),//24*60*60*1000
    EVERY_WEEK(604800000L,2,"每周"),//7*24*60*60*1000
    EVERY_MONTH(2592000000L,3,"每月"),//30*24*60*60*1000
    NEVERY(-1L,4,"永不"),//
    ;

    private Long time;
    private Integer code;
    private String desc;

    DmpDataUpdatePeridEnum(Long time, Integer code, String desc) {
        this.time = time;
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer, DmpDataUpdatePeridEnum> codeQueryMap = new ConcurrentHashMap<>();
    private static Map<Long, DmpDataUpdatePeridEnum> timeQueryMap = new ConcurrentHashMap<>();

    static {
        for (DmpDataUpdatePeridEnum typeEnum : DmpDataUpdatePeridEnum.values()) {
            codeQueryMap.put(typeEnum.code, typeEnum);
            timeQueryMap.put(typeEnum.getTime(),typeEnum);
        }
    }

    public Long getTime() {
        return time;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DmpDataUpdatePeridEnum getByCode(Integer code){
        return null == code ? null : codeQueryMap.get(code);
    }

    public static DmpDataUpdatePeridEnum getByTime(Long time){
        return null == time ? null : timeQueryMap.get(time);
    }

}
