/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAdvertMaterialService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年12月23日下午3:34:25<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialTestPlanDto;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialTestPlanRelation;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ClassName: RemoteAdvertMaterialService <br/>
 * Function: 广告素材开放给前端系统调用的接口定义. <br/>
 * date: 2016年12月23日 下午3:34:25 <br/>
 *
 * @author leiliang
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertMaterialTestPlanService {

    /**
     * 根据广告id 查询 正在运行中的 测试计划
     *
     * @param advertId
     * @return
     */
    AdvertMaterialTestPlanDto queryRunTestByAdvertId(Long advertId);

    /**
     * 根据广告id 查询 所有的 测试计划
     *
     * @param advertId
     * @return
     */
    List<AdvertMaterialTestPlanDto> queryAllTestByAdvertId(Long advertId);


    /**
     * @param planId
     * @return
     */
    AdvertMaterialTestPlanDto queryRunTestByPlanId(Long planId);

    /**
     *
     * @param dto
     */
    Long insertTestPlan(AdvertMaterialTestPlanDto dto) throws BizException;

    /**
     * 改变计划开关状态
     * @param planId
     * @param enableState
     */
    void updateTestPlanEnableState(Long planId, Integer enableState);

    /**
     * 改变计划开关状态和结束时间
     * @param planId
     * @param enableState
     * @param time
     */
    void updateTestPlanEnableStateAndEndtime(Long planId, Integer enableState, String time) throws BizException;

    /**
     * 根据测试计划id,查询测试落地页和素材的关系
     * @param ids
     * @return
     */
    List<AdvertMaterialTestPlanRelation> selectByPlanIdList(List<Long> ids);

    /**
     * 同步素材测试到实验平台
     * TestController 使用
     *
     * @return 同步的计划ID
     */
    Map<String, Set<Long>> syncMaterialTest();
}
