package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.app.AppPackageRegularDto;
import cn.com.duiba.tuia.core.api.dto.rsp.app.RspAppPackDto;
import cn.com.duiba.tuia.core.api.dto.rsp.app.RspAppSimpleInfoDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAppPackageRegularService {

    /**
     * 查看规则
     * @param appPackageId
     * @return
     */
    RspAppPackDto regular(Long appPackageId);

    /**
     * 重新计算规则
     * @param appPackageRegularDto-计算的规则
     * @return
     */
    List<RspAppSimpleInfoDto> reCalculate(AppPackageRegularDto appPackageRegularDto);

    /**
     * 将媒体列表先同步到对应的包中，将对应的包同步对应的广告(媒体超过999个提示用户，前端判断appIds)
     * @param appPackageId -- 同步对应包下的媒体
     * @param appIds       -- 需要同步的媒体列表
     * @return
     */
    Boolean synchronzieRelateAdvert(Long appPackageId,List<String> appIds);

    /**
     * 获取流量包下媒体详情列表
     * @param appPackageId
     * @return
     */
    List<RspAppSimpleInfoDto> getAppsByPackageId(Long advertId,Long appPackageId,Long orientPackageId);

    /**
     * 获取多个流量包下媒体详情列表
     * @param appPackageIds
     * @return
     */
    List<RspAppSimpleInfoDto> getAppsByPackageIds(List<Long> appPackageIds);

    /**
     * 获取多个媒体对应的详情
     * @param appIds
     * @return
     */
    List<RspAppSimpleInfoDto> getAppsByIds(List<Long> appIds);

}
