package cn.com.duiba.tuia.core.api.remoteservice.media;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaAlreadSlotBlackReq;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaAlreadSlotWhiteReq;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaCopySlotBlackReq;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaCopySlotWhiteReq;
import cn.com.duiba.tuia.core.api.dto.media.response.*;
import cn.com.duiba.tuia.core.api.dto.slot.SlotChooseAdvertDto;

import java.util.List;

/**
 * @function 广告位黑名单
 */
@AdvancedFeignClient
public interface RemoteMediaAppBlackListService {

    /**
     * 提供广告位黑名单数量,福袋状态（应用管理）
     */
//    RspMediaSlotWhiteDto getSlotBlackCountAndLuckBagStatus(Long slotId);


    RspMediaSlotAdvertAccountDto getBlackAdvertAndAccountBySlotIds(List<Long> slotIds);

    /**
     * 提供覆盖黑名单接口
     * @param mediaCopySlotWhiteReq
     * @return
     */
    Boolean coverMediaSlotBlack(MediaCopySlotWhiteReq mediaCopySlotWhiteReq);

    /**
     * 提供复制黑名单接口，参数 原广告位 solt1，目标广告位 solt2，sot3，。。。总共不超过10个。
     * （如果广告位同时在广告主，又在广告位黑名单中，复制时候只需要复制广告主就可以了）
     */
    Boolean copyMediaSlotBlack(MediaCopySlotWhiteReq mediaCopySlotWhiteReq);


    /**
     * 批量将广告加入到广告位对应的黑名单中
     */
    Boolean batchAddAdvertToBlackList(Long slotId, List<Long> advertIds) throws BizException;


    /**
     * 批量将广告主加入到广告主广告位黑名单中
     */
    Boolean batchAddAccountToBlackList(Long slotId, List<Long> accountIds) throws BizException;

    /**
     * 单个将广告从广告位黑名单中移除
     */
    Boolean removeAdvertFromBlackList(Long slotId, Long advertId);


    /**
     * 单个将广告主从广告主黑名单中移除
     */
    Boolean removeAccountFromBlackList(Long slotId, Long accountId);


    /**
     * 查询广告已添加到广告位黑名单下的广告计划(需要分页) List<RspMediaSlotAdvertBlackDto>
     */
    PageDto<RspMediaSlotAdvertWhiteDto> getAlreadAdvertSlotBlackList(
            MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);



    /**
     * 查询广告主已添加到广告位黑名单下的广告主（需要分页）List<RspMediaSlotAccountBlackDto>
     */
    PageDto<RspMediaSlotAccountWhiteDto> getAlreadAccountSlotBlackList(
            MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);


    /**
     * 根据广告id/广告名称/广告主id/广告主名称   查询广告信息（需要分页） List<RspMediaSlotAdvertBlackDto>
     */

    PageDto<RspMediaSlotAdvertWhiteDto> getAdvertSlotBlackList(
            MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);


    /**
     * 根据广告主id/广告主名称 查询广告主信息（需要分页）List<RspMediaSlotAccountBlackDto
     */
    PageDto<RspMediaSlotAccountWhiteDto> getAccountSlotBlackList(
            MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);

    /**
     * 将广告从广告位黑名单中批量删除
     */
    Boolean batchRemoveAdvertFromBlackList(Long slotId, List<Long> advertIds);

    /**
     * 将广告主从广告主黑名单中批量删除
     */
    Boolean batchRemoveAccountFromBlackList(Long slotId, List<Long> accountIds);

    /**
     * 根据广告位 查询 定制的可投广告列表
     * @param slotIds
     * @Param resourceType 枚举值见 @SlotChooseAdvertTypeEnum，如果传null 则表示 查询全部
     * @return
     */
    List<SlotChooseAdvertDto> getChoosenAdvertsBySlotIds(List<Long> slotIds,Integer resourceType) throws BizException;

    /**
     * 分页查询 数据
     * @param slotId
     * @param resourceType
     * @param pageSize 页大小，必填，传-1返回全部
     * @param pageCount 页码，必填，从1开始
     * @return
     * @throws BizException
     */
    PageDto<SlotChooseAdvertDto> pageGetChoosenAdvertsBySlotIds(Long slotId, Integer resourceType, List<String> resourceIds, Integer pageSize, Integer pageCount) throws BizException;

    /**
     * 提供覆盖接口
     * @param mediaCopySlotWhiteReq
     * @return
     */
    Boolean coverSlotChooseAdvert(MediaCopySlotWhiteReq mediaCopySlotWhiteReq) throws BizException;

    /**
     * 提供拷贝接口
     */
    Boolean copySlotChooseAdvert(MediaCopySlotWhiteReq mediaCopySlotWhiteReq) throws BizException;

    /**
     * 批量将广告加入到广告位定制广告名单中
     */
    Boolean batchAddSlotChooseAdvert(List<SlotChooseAdvertDto> addData) throws BizException;

    /**
     * 批量将广告从广告位定制单中移除
     */
    Boolean batchRemoveSlotChooseAdvert(List<Long> rmDataIds) throws BizException;

    /**
     * 清除广告位下所有数据
     * @param targetSlotIds
     * @return
     */
    Boolean clearSlotsData(List<Long> targetSlotIds);

}
