package cn.com.duiba.tuia.core.api.remoteservice.tag;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.rsp.tag.MakeTagDto;

import java.util.List;


/**
 * 各大平台打标后存储到adevrt这边的打标
 *
 * @author fanjia
 * @date 2021/5/17 下午2:52
 */
@AdvancedFeignClient

public interface RemoveMakeTagService {

    /**
     * 根据数据id+数据来源 查询存储在advert平台的打标标签信息
     *
     * @param sourceId   数据id  例如积木平台创建的落地页对应的id
     * @param sourceType 平台来源  1代表积木 2代表百奇
     * @return cn.com.duiba.tuia.core.api.dto.rsp.tag.MakeTagDto
     * @author fanjia
     * @date 2021/5/11 下午1:37
     */
    MakeTagDto getMakeTag(Long sourceId, Integer sourceType);



  /**
   *根据数据id集合+数据来源 查询存储在advert平台的打标标签信息
   * @author fanjia
   * @date 2021/5/18 下午7:24
   * @param sourceIdList
   * @param sourceType
   * @return java.util.List<cn.com.duiba.tuia.core.api.dto.rsp.tag.MakeTagDto>
   */
    List<MakeTagDto> listMakeTag(List<Long> sourceIdList, Integer sourceType);
    /**
     * 插入打标数据 唯一索引重复 会更新
     *
     * @param makeTagDto
     * @return java.lang.Integer
     * @author fanjia
     * @date 2021/5/11 下午1:44
     */

    Integer insertOrUpdateMakeTag(MakeTagDto makeTagDto) throws BizException;


    /**
     * 更新打标数据
     *
     * @param makeTagDto
     * @return java.lang.Integer
     * @author fanjia
     * @date 2021/5/11 下午1:44
     */

    Integer updateMakeTag(MakeTagDto makeTagDto);

    /**
     * 删除打标数据
     * * @param sourceId   数据id  例如积木平台创建的落地页对应的id
     *
     * @param sourceType 平台来源  1代表积木 2代表百奇
     * @return java.lang.Integer
     */

    Integer deleteMakeTag(Long sourceId, Integer sourceType);


}
