/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.enums.fincance;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public enum BalanceRecordType {
    BALANCE_RECHARGE(10, "\u8d26\u53f7\u5145\u503c", "\u5145\u503c\u73b0\u91d1", -1),
    BALANCE_RECHARGE_OFFLINE(101, "\u8d26\u53f7\u5145\u503c", "\u5145\u503c\u73b0\u91d1(\u7ebf\u4e0b\u8f6c\u8d26)", 2),
    BALANCE_RECHARGE_MOVE(103, "\u8d26\u53f7\u5145\u503c", "\u5145\u503c\u73b0\u91d1(\u8d26\u6237\u8fc1\u79fb)", 6),
    BALANCE_RECHARGE_CREDIT(105, "\u8d26\u53f7\u5145\u503c", "\u5145\u503c\u73b0\u91d1(\u6388\u4fe1)", 9),
    BALANCE_RECHARGE_OTHER(106, "\u8d26\u53f7\u5145\u503c", "\u5145\u503c\u73b0\u91d1(\u5176\u4ed6)", 0),
    BALANCE_RECHARGE_AD_IN(12, "\u4ee3\u7406\u5546\u5212\u8d26", "\u4ee3\u7406\u5546\u5212\u8d26(\u6536\u5165)", 10),
    BALANCE_RECHARGE_AD_IN_CASH(121, "\u4ee3\u7406\u5546\u5212\u8d26", "\u4ee3\u7406\u5546\u5212\u8d26(\u73b0\u91d1\u6536\u5165)", 10),
    BALANCE_RECHARGE_AD_IN_CASH_BACK(122, "\u4ee3\u7406\u5546\u5212\u8d26", "\u4ee3\u7406\u5546\u5212\u8d26(\u8fd4\u8d27\u6536\u5165)", 10),
    BALANCE_PRESENT(13, "\u8d60\u9001\u91d1\u989d", "\u5145\u503c\u8fd4\u8d27", -1),
    BALANCE_PRESENT_ONLINE(131, "\u8d60\u9001\u91d1\u989d", "\u5145\u503c\u8fd4\u8d27(\u7ebf\u4e0a\u5145\u503c)", 1),
    BALANCE_PRESENT_OFFLINE(132, "\u8d60\u9001\u91d1\u989d", "\u5145\u503c\u8fd4\u8d27(\u7ebf\u4e0b\u8f6c\u8d26)", 2),
    BALANCE_PRESENT_BACK(134, "\u8d60\u9001\u91d1\u989d", "\u5145\u503c\u8fd4\u8d27(\u5b63\u5ea6\u8fd4\u8d27)", 5),
    BALANCE_PRESENT_MOVE(135, "\u8d60\u9001\u91d1\u989d", "\u5145\u503c\u8fd4\u8d27(\u8d26\u6237\u8fc1\u79fb)", 6),
    BALANCE_PRESENT_OTHER(137, "\u8d60\u9001\u91d1\u989d", "\u5145\u503c\u8fd4\u8d27(\u5176\u4ed6)", 0),
    CASH_BACK_COMPENSATE_AUTO(138, "\u8d60\u9001\u91d1\u989d", "\u8d54\u4ed8\u8fd4\u8d27(\u81ea\u52a8\u5145\u503c)", 15),
    BALANCE_THIRD_PARTY_RECHARGE(14, "\u5728\u7ebf\u5145\u503c", "\u4ee3\u7406\u5546\u5728\u7ebf\u5145\u503c", 1),
    BALANCE_CONSUMER_CORRECTION_IN(15, "\u6d88\u8d39\u4fee\u6b63", "\u6d88\u8d39\u4fee\u6b63", -1),
    BALANCE_CONSUMER_CORRECTION_IN_CASH(151, "\u6d88\u8d39\u4fee\u6b63", "\u6d88\u8d39\u4fee\u6b63(\u5145\u503c\u73b0\u91d1)", -1),
    BALANCE_CONSUMER_CORRECTION_IN_CASH_BACK(152, "\u6d88\u8d39\u4fee\u6b63", "\u6d88\u8d39\u4fee\u6b63(\u5145\u503c\u8fd4\u8d27)", -1),
    BALANCE_RECHARGE_ADJUST(102, "\u6d88\u8d39\u4fee\u6b63", "\u5145\u503c\u73b0\u91d1(\u6d88\u8d39\u8c03\u6574)", 4),
    BALANCE_RECHARGE_FIX(104, "\u6d88\u8d39\u4fee\u6b63", "\u5145\u503c\u73b0\u91d1(\u4fee\u504f)", 7),
    BALANCE_PRESENT_ADJUST(133, "\u6d88\u8d39\u4fee\u6b63", "\u5145\u503c\u8fd4\u8d27(\u6d88\u8d39\u8c03\u6574)", 4),
    BALANCE_PRESENT_FIX(136, "\u6d88\u8d39\u4fee\u6b63", "\u5145\u503c\u8fd4\u8d27(\u4fee\u504f)", 7),
    BALANCE_CALL_BACK_AGENT_IN(16, "\u4ee3\u7406\u5546\u56de\u62e8", "\u4ee3\u7406\u5546\u56de\u62e8(\u6536\u5165)", -1),
    BALANCE_CALL_BACK_AGENT_IN_CASH(161, "\u4ee3\u7406\u5546\u56de\u62e8", "\u4ee3\u7406\u5546\u56de\u62e8(\u73b0\u91d1\u6536\u5165)", -1),
    BALANCE_CALL_BACK_AGENT_IN_CASH_BACK(162, "\u4ee3\u7406\u5546\u56de\u62e8", "\u4ee3\u7406\u5546\u56de\u62e8(\u8fd4\u8d27\u6536\u5165)", -1),
    ADVERTISER_THIRD_PARTY_RECHARGE(17, "\u5e7f\u544a\u4e3b\u5145\u503c", "\u5e7f\u544a\u4e3b\u5728\u7ebf\u5145\u503c", 1),
    BALANCE_ADVERT_EXPEND(20, "\u5e7f\u544a\u6263\u8d39", "\u5e7f\u544a\u6263\u8d39", -1),
    BALANCE_DEDUCTED(21, "\u6263\u9664\u73b0\u91d1", "\u6263\u9664\u91d1\u989d", -1),
    BALANCE_DEDUCTED_CASH(211, "\u6263\u9664\u73b0\u91d1", "\u6263\u9664\u73b0\u91d1(\u9000\u6b3e\u6263\u9664)", 3),
    BALANCE_DEDUCTED_MOVE(213, "\u6263\u9664\u73b0\u91d1", "\u6263\u9664\u73b0\u91d1(\u8d26\u6237\u8fc1\u79fb)", 6),
    BALANCE_DEDUCTED_OTHER(215, "\u6263\u9664\u73b0\u91d1", "\u6263\u9664\u73b0\u91d1(\u5176\u4ed6)", 0),
    BALANCE_RECHARGE_AGENT_OUT(22, "\u4ee3\u7406\u5546\u5212\u8d26", "\u4ee3\u7406\u5546\u5212\u8d26(\u652f\u51fa)", 10),
    BALANCE_RECHARGE_AGENT_OUT_CASH(221, "\u4ee3\u7406\u5546\u5212\u8d26", "\u4ee3\u7406\u5546\u5212\u8d26(\u73b0\u91d1\u652f\u51fa)", 10),
    BALANCE_RECHARGE_AGENT_OUT_CASH_BACK(222, "\u4ee3\u7406\u5546\u5212\u8d26", "\u4ee3\u7406\u5546\u5212\u8d26(\u8fd4\u8d27\u652f\u51fa)", 10),
    BALANCE_CONSUMER_CORRECTION_OUT(24, "\u6d88\u8d39\u4fee\u6b63", "\u6d88\u8d39\u4fee\u6b63", -1),
    BALANCE_CONSUMER_CORRECTION_OUT_CASH(241, "\u6d88\u8d39\u4fee\u6b63", "\u6d88\u8d39\u4fee\u6b63(\u6263\u9664\u73b0\u91d1)", -1),
    BALANCE_CONSUMER_CORRECTION_OUT_CASH_BACK(242, "\u6d88\u8d39\u4fee\u6b63", "\u6d88\u8d39\u4fee\u6b63(\u6263\u9664\u8fd4\u8d27)", -1),
    BALANCE_DEDUCTED_ADJUST(212, "\u6d88\u8d39\u4fee\u6b63", "\u6263\u9664\u73b0\u91d1(\u6d88\u8d39\u8c03\u6574)", 4),
    BALANCE_DEDUCTED_FIX(214, "\u6d88\u8d39\u4fee\u6b63", "\u6263\u9664\u73b0\u91d1(\u4fee\u504f)", 7),
    DEDUCTED_CASH_BACK_ADJUST(262, "\u6d88\u8d39\u4fee\u6b63", "\u6263\u9664\u8fd4\u8d27(\u6d88\u8d39\u8c03\u6574)", 4),
    DEDUCTED_CASH_BACK_FIX(264, "\u6d88\u8d39\u4fee\u6b63", "\u6263\u9664\u8fd4\u8d27(\u4fee\u504f)", 7),
    BALANCE_CALL_BACK_AD_OUT(25, "\u4ee3\u7406\u5546\u56de\u62e8", "\u4ee3\u7406\u5546\u56de\u62e8(\u652f\u51fa)", -1),
    BALANCE_CALL_BACK_AD_OUT_CASH(251, "\u4ee3\u7406\u5546\u56de\u62e8", "\u4ee3\u7406\u5546\u56de\u62e8(\u73b0\u91d1\u652f\u51fa)", -1),
    BALANCE_CALL_BACK_AD_OUT_CASH_BACK(252, "\u4ee3\u7406\u5546\u56de\u62e8", "\u4ee3\u7406\u5546\u56de\u62e8(\u8fd4\u8d27\u652f\u51fa)", -1),
    BALANCE_DEDUCTED_CASH_BACK(26, "\u6263\u9664\u8fd4\u8d27", "\u6263\u9664\u8fd4\u8d27", -1),
    DEDUCTED_CASH_BACK_REFUND(261, "\u6263\u9664\u8fd4\u8d27", "\u6263\u9664\u8fd4\u8d27(\u9000\u6b3e\u6263\u9664)", 3),
    DEDUCTED_CASH_BACK_MOVE(263, "\u6263\u9664\u8fd4\u8d27", "\u6263\u9664\u8fd4\u8d27(\u8d26\u6237\u8fc1\u79fb)", 6),
    DEDUCTED_CASH_BACK_QUARTER(265, "\u6263\u9664\u8fd4\u8d27", "\u6263\u9664\u8fd4\u8d27(\u5b63\u8fd4\u6263\u9664)", 8),
    DEDUCTED_CASH_BACK_OTHER(266, "\u6263\u9664\u8fd4\u8d27", "\u6263\u9664\u8fd4\u8d27(\u5176\u4ed6)", 0);

    private int type;
    private String remark;
    private String detail;
    private int rechargeType;
    private static Map<Integer, BalanceRecordType> enumMap;

    private BalanceRecordType(int type, String remark, String detail, int rechargeType) {
        this.type = type;
        this.remark = remark;
        this.detail = detail;
        this.rechargeType = rechargeType;
    }

    public static BalanceRecordType getByType(Integer type) {
        BalanceRecordType balanceRecordType = enumMap.get(type);
        if (balanceRecordType == null) {
            throw new BalanceRecordNonExistsException();
        }
        return balanceRecordType;
    }

    public static List<Integer> getRecordTypeListByRechargeType(Integer rechargeType) {
        ArrayList recordTypeList = Lists.newArrayList();
        if (rechargeType == null) {
            return recordTypeList;
        }
        for (BalanceRecordType balanceRecordType : BalanceRecordType.values()) {
            int balanceRechargeType = balanceRecordType.getRechargeType();
            if (balanceRechargeType != rechargeType) continue;
            recordTypeList.add(balanceRecordType.getType());
        }
        return recordTypeList;
    }

    public static String getDetailByType(int type) {
        for (BalanceRecordType balanceRecordType : BalanceRecordType.values()) {
            if (balanceRecordType.getType() != type) continue;
            return balanceRecordType.getDetail();
        }
        return "";
    }

    public String getDetail() {
        return this.detail;
    }

    public int getType() {
        return this.type;
    }

    public String getRemark() {
        return this.remark;
    }

    public int getRechargeType() {
        return this.rechargeType;
    }

    static {
        enumMap = Maps.newHashMap();
        for (BalanceRecordType typeEnum : BalanceRecordType.values()) {
            enumMap.put(typeEnum.type, typeEnum);
        }
    }

    private static class BalanceRecordNonExistsException
    extends RuntimeException {
        BalanceRecordNonExistsException() {
            super("\u4e0d\u5b58\u5728\u7684\u8d22\u52a1\u8bb0\u5f55\u7c7b\u578b");
        }
    }
}

