package cn.com.duiba.tuia.core.api.dto.rta;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class LimitConfigDto implements Serializable {

    private static final long serialVersionUID = -8627179140069440769L;

    /**
     * 自增id
     */
    private Long id;

    /**
     * 限流配置id
     */
    private Long configId;

    /**
     * 媒体应用名称
     */
    private String appName;

    /**
     * 媒体应用代码名
     */
    private String appCodeName;

    /**
     * 媒体应用密钥
     */
    private String appSecret;

    /**
     * 渠道id
     */
    private Long channelId;

    /**
     * 对外的渠道编码
     */
    private String outerChannelCode;

    /**
     * API对接方式
     * @see cn.com.duiba.tuia.core.api.constant.RtaApiConnectionType
     */
    private Integer connectionType;

    /**
     * 应用名称
     */
    private String serviceName;

    /**
     * 请求路径
     */
    private String path;

    /**
     * 最高qps
     */
    private Long qps;

    /**
     * 限流配置状态
     */
    private Integer configStatus;

    /**
     * 变更时间
     */
    private Date gmtModified;

}
