package cn.com.duiba.tuia.core.api.dto.rta;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2022/9/22
 * @Description
 * @Param
 * @return
 **/
@Data
public class RtaOfflineTaskConfigDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键id
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 删除标识
     */
    private Integer isDeleted;
    /**
     * 调用方式 1-定时调用
     */
    private Integer scheduleType;
    /**
     * 调用时间
     */
    private String scheduleTime;
    /**
     * 数据源
     */
    private String dataSource;
    /**
     * 广告主rta
     */
    private String advertiserRta;
    /**
     * 广告主rta列表
     */
    private List<Long> advertiserRtaList;
    /**
     * 任务状态 0-关闭 1-开启
     */
    private Integer scheduleStatus;
    /**
     * 调用方式 1-单次 2-批量
     */
    private Integer callMethod;
    /**
     * 创建人
     */
    private Long creator;

    private String creatorName;

    private Integer pageSize;

    private Integer currentPage;

    private Integer rowStart;

    private Long lastId;

    private Integer limitCount;

    private String orderBy;

    private String order = "desc";
}
