package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 账户来源
 *
 * @author chencheng
 * @version
 */
public enum AccountSourceTypeEnum {

    /** 来自兑吧 */
    DUIBA(0, "兑吧"),

    /** 来自推啊 */
    TUIA(1, "推啊");


    /** 代码 */
    private Integer code;
    /** 描述 */
    private String  desc;

    private AccountSourceTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer, AccountSourceTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AccountSourceTypeEnum typeEnum : AccountSourceTypeEnum.values()) {
            enumMap.put(typeEnum.code, typeEnum);
        }
    }

    public static AccountSourceTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
