package cn.com.duiba.tuia.core.api.enums.compensate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 提现申请状态枚举
 *
 * @author zhangbaiqiang
 * @date 2021/4/27
 */
@Getter
@AllArgsConstructor
public enum WithdrawApplyStateEnum {

    INVISIBLE(0, "不可见"),
    READY_TO_APPLY(1, "待申请"),
    ALREADY_APPLIED(2, "已申请");

    private final Integer state;
    private final String  desc;

    public static String getDesc(Integer state) {
        return Stream.of(WithdrawApplyStateEnum.values())
                .filter(e -> Objects.equals(e.getState(), state))
                .findFirst()
                .map(WithdrawApplyStateEnum::getDesc)
                .orElse(null);
    }
}
