package cn.com.duiba.tuia.core.api.enums.reflow;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * @author Wangpf
 * @description
 * @date 2021/11/24 4:10 下午
 * <p>
 * /**
 * * 计划状态
 * *
 * * 任务状态 1:刷量中 2:已暂停 3:回流结束 4:回流中止
 */

public enum AutoReflowPlanStatusEnum {

    AUTO_REFLOW_NOTYET(0, "未开始"),

    AUTO_REFLOW_ING(1, "刷量中"),

    AUTO_REFLOW_PAUSE(2, "已暂停"),

    AUTO_REFLOW_END(3, "回流结束"),

    AUTO_REFLOW_UNKNOWN_ERROR(4, "回流中止");

    private final Integer planStatus;

    private final String desc;

    AutoReflowPlanStatusEnum(Integer planStatus, String desc) {
        this.planStatus = planStatus;
        this.desc = desc;
    }

    public Integer getPlanStatus() {
        return planStatus;
    }

    public String getDesc() {
        return desc;
    }

    public static List<Integer> getPlanStatusIng(){
        return Lists.newArrayList(AUTO_REFLOW_ING.getPlanStatus(),AUTO_REFLOW_UNKNOWN_ERROR.getPlanStatus());
    }

}
