package cn.com.duiba.tuia.core.api.remoteservice.account;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.account.rsp.AdvertiserAccountDto;
import cn.com.duiba.tuia.core.api.dto.account.rsp.AdvertiserIndustryResultDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdvertiserAccountService {

    /**
     * 模糊查询广告主信息 (调用端注意控制返回数据数量)
     * @param companyName
     * @return
     */
    List<AdvertiserAccountDto> getAdvertiserAccountFuzzy(String companyName);

    /**
     * 模糊查询数量,用于控制返回数量
     * @param companyName
     * @return
     */
    Integer getAdvertiserAccountFuzzyCount(String companyName);

    /**
     * 获取广告主投放行业list
     * @param
     * @return
     */
    List<AdvertiserIndustryResultDto> getAdvertiseIndustry(List<Long> advertIds);

}
