package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.app.CollectAppDto;
import cn.com.duiba.tuia.core.api.dto.app.CollectAppReq;
import cn.com.duiba.tuia.core.api.dto.app.CollectAppRuleReq;
import cn.com.duiba.tuia.core.api.dto.statistics.CollectAppBasicInfoDto;

import java.util.List;

/**
 *
 */
@AdvancedFeignClient
public interface RemoteCollectAppService {
    /**
     * 分页查询聚合媒体数据
     *
     * @param req 查询条件
     * @return
     */
    PageDto<CollectAppDto> queryPage(CollectAppReq req);

    /**
     * 根据日期和媒体id列表查询媒体数据
     * @param curDate
     * @param appIds
     * @return
     */
    List<CollectAppBasicInfoDto> getAppInfoByDateApps(String curDate, List<Long> appIds);

    /**
     * 获取聚合规则的媒体数据现在300条
     * @param req
     * @return
     */
    List<CollectAppBasicInfoDto> getCollectAppRuleInfos(CollectAppRuleReq req);

    /**
     * 保存聚合媒体数据
     */
    Integer saveCollectAppInfo(CollectAppDto dto);

    //根据聚合媒体名称查数据
    CollectAppDto getByName(String collectAppName);

    //根据行业标签查询聚合媒体信息
    List<CollectAppDto> getByTradeTag(CollectAppRuleReq req);

}
