package cn.com.duiba.tuia.core.api.remoteservice.coupon;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.coupon.AdvertNewCouponGoodsDto;

import java.util.List;

/**
 * 优惠券相关
 * zhangmeng
 * 2019.12.24
 */
@AdvancedFeignClient
public interface RemoteAdvertCouponGoodsBackendService {

    /**
     * 创建广告卷商品.
     *
     * @param goods the goods
     * @return the dubbo result< boolean>
     */
    Boolean createAdvertCouponGoods(AdvertNewCouponGoodsDto goods) throws BizException;

    /**
     * 修改广告卷商品.
     *
     * @param goods the goods
     * @return the dubbo result< boolean>
     */
    Boolean editAdvertCouponGoods(AdvertNewCouponGoodsDto goods)throws BizException;

    /**
     * 删除广告卷(逻辑删除).
     *
     * @param acgId 优惠卷ID
     * @return the dubbo result< boolean>
     *//*
    DubboResult<Boolean> deleteGoods(Long acgId)throws BizException;*/

    /**
     * 查询广告卷信息.
     *
     * @param advertId 优惠卷ID
     * @return the dubbo result< advert coupon goods dto>
     */
    AdvertNewCouponGoodsDto find(Long advertId)throws BizException;

    /**
     * 切换优惠券类型
     * @param t 类型
     * @return
     *//*
    @Deprecated
    DubboResult<Boolean> changeACGType(ChangeACGTypeDto t);

    *//**
     * 切换优惠券类型
     * @param t 类型
     * @return
     *//*
    DubboResult<Boolean> changeACGTypeApi(ChangeACGTypeApiDto t);*/

    /**
     * 优根据广告优惠券名称返回广告券ids.
     *
     * @param couponName 优惠券名称
     * @return the dubbo result< advert coupon goods dto>
     */
    List<Long> findByNameGoodIds(String couponName)throws BizException;

    /**
     * 注意acgIdList的长度最多只允许（一次查询）300个，超过直接抛出异常，因此若超过长度调用方需分批次查询
     * 批量查询广告券推广地址
     * @param acgIdList 优惠券ID列表
     * @return
     */
    List<AdvertNewCouponGoodsDto> findByAcgIds(List<Long> acgIdList)throws BizException;

    /**
     * 查询出落地页关联的所有广告id
     * @param link
     * @return
     */
    List<Long> selectAdvetIdsByLink(String link)throws BizException;
}
