package cn.com.duiba.tuia.core.api.dto.company_dynamic;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: BaseCompanyDynamicDto
 * Function: 抽取出来的 公司动态相关属性
 * Date:     2019/7/3 0003 上午 11:00
 */
public class BaseCompanyDynamicDto implements Serializable {

    private static final long serialVersionUID = 1332777795754803341L;
    @ApiModelProperty(value = "动态信息的ID")
    private Long id;

    @ApiModelProperty(value = "主题")
    @NotNull
    private String topic;

    @ApiModelProperty("新闻来源")
    @NotNull
    private String newsFrom;

    @ApiModelProperty("新闻来源链接")
    @NotNull
    private String newsFromLink;

    @ApiModelProperty("日期 yyyy-MM-dd")
    @NotNull
    private String date;

    @ApiModelProperty("摘要描述")
    @NotNull
    private String abstractDesc;

    @ApiModelProperty("正文描述")
    @NotNull
    private String context;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getNewsFrom() {
        return newsFrom;
    }

    public void setNewsFrom(String newsFrom) {
        this.newsFrom = newsFrom;
    }

    public String getNewsFromLink() {
        return newsFromLink;
    }

    public void setNewsFromLink(String newsFromLink) {
        this.newsFromLink = newsFromLink;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getAbstractDesc() {
        return abstractDesc;
    }

    public void setAbstractDesc(String abstractDesc) {
        this.abstractDesc = abstractDesc;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }
}
