package cn.com.duiba.tuia.core.api.dto.media.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * @author yuantong
 * @date 2020/04/13
 * @function
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class MediaAlreadSlotBlackReq implements Serializable {


    private static final long serialVersionUID = -8652858850978628304L;

    /**
     * 广告位id
     */
    private Long slotId;

    /**
     * 广告ids
     */
    private List<Long> advertIds;

    /**
     * 广告名称
     */
    private String advertName;

    /**
     * 广告主名称
     */
    private String accountName;

    /**
     * 广告主列表
     */
    private List<Long> accountIds;

    /**
     * 每页大小
     */
    private Integer pageSize;

    /**
     * 第几页
     */
    private Integer pageCount;

}
