package cn.com.duiba.tuia.core.api.dto.permisson;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import cn.com.duiba.tuia.core.api.dto.BaseDto;

import java.util.List;

/**
 * Created by zhengjy on 2017/6/5.
 */
@ApiModel("数据源权限参数")
public class DataPermissonDto extends BaseDto {

    private static final long serialVersionUID = 5143933030739352226L;

    @ApiModelProperty("数据源id")
    private Long              sourceId;

    // 数据源类型tuia-core,@DataPermissonSourceTypeEnum
    @ApiModelProperty("数据源类型：advert-广告/account-广告主")
    private String            sourceType;

    @ApiModelProperty("AE名称")
    private String            aeName;

    @ApiModelProperty("AE ID")
    private Long              aeId;

    @ApiModelProperty("销售名称")
    private String            sellName;

    @ApiModelProperty("销售id")
    private Long              sellId;

    @ApiModelProperty("新行业ID")
    private Long              newTradeId;
    
    @ApiModelProperty("新行业名称")
    private String            newTradeName;

    @ApiModelProperty("AE列表")
    private List<Long> aeIds;

    @ApiModelProperty("销售列表")
    private List<Long> sellIds;

    private List<Long> sourceIdList;

    public List<Long> getSellIds() {
        return sellIds;
    }

    public void setSellIds(List<Long> sellIds) {
        this.sellIds = sellIds;
    }

    public List<Long> getSourceIdList() {
        return sourceIdList;
    }

    public void setSourceIdList(List<Long> sourceIdList) {
        this.sourceIdList = sourceIdList;
    }

    public List<Long> getAeIds() {
        return aeIds;
    }

    public void setAeIds(List<Long> aeIds) {
        this.aeIds = aeIds;
    }

    /**
     * newTradeName.
     *
     * @return  the newTradeName
     * @since   JDK 1.8
     */
    public String getNewTradeName() {
        return newTradeName;
    }

    /**
     * newTradeName.
     *
     * @param   newTradeName    the newTradeName to set
     * @since   JDK 1.8
     */
    public void setNewTradeName(String newTradeName) {
        this.newTradeName = newTradeName;
    }

    /**
     * newTradeId.
     *
     * @return the newTradeId
     * @since JDK 1.8
     */
    public Long getNewTradeId() {
        return newTradeId;
    }

    /**
     * newTradeId.
     *
     * @param newTradeId the newTradeId to set
     * @since JDK 1.8
     */
    public void setNewTradeId(Long newTradeId) {
        this.newTradeId = newTradeId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getAeName() {
        return aeName;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public Long getAeId() {
        return aeId;
    }

    public void setAeId(Long aeId) {
        this.aeId = aeId;
    }

    public String getSellName() {
        return sellName;
    }

    public void setSellName(String sellName) {
        this.sellName = sellName;
    }

    public Long getSellId() {
        return sellId;
    }

    public void setSellId(Long sellId) {
        this.sellId = sellId;
    }

}
