/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteAdvertAbnormalMonitoringService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.advert
 * Date:2019年3月26日下午8:33:09
 * Copyright (c) 2019, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.advert;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertAbnormalMonitoringDto;

/**
 * ClassName:RemoteAdvertAbnormalMonitoringService <br/>
 * Function: 广告下统一监控规则remote接口. <br/>
 * Date:     2019年3月26日 下午8:33:09 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAdvertAbnormalMonitoringService {
    /**
     * 
     * listByAdvertIds:(根据广告查询). <br/>
     *
     * @author chencheng
     * @param advertId
     * @return
     * @since JDK 1.8
     */
    List<AdvertAbnormalMonitoringDto> listByAdvertId(Long advertId);
    
    /**
     * 
     * listByAdvertIds:(根据id查询). <br/>
     *
     * @author chencheng
     * @param id
     * @return
     * @since JDK 1.8
     */
    AdvertAbnormalMonitoringDto selectById(Long id);

    /**
     * 
     * insert:(插入一条监控规则). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @since JDK 1.8
     */
    int insertAdvertAbnormalMonitoring(AdvertAbnormalMonitoringDto dto);

    /**
     * 
     * updateByAdvertId:(修改监控规则). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @since JDK 1.8
     */
    int updateAdvertAbnormalMonitoring(AdvertAbnormalMonitoringDto dto);

    /**
     * 
     * delete:(删除监控规则). <br/>
     *
     * @author chencheng
     * @param id
     * @return
     * @since JDK 1.8
     */
    int deleteAdvertAbnormalMonitoring(Long id);
}

