package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertHijackDto;
import cn.com.duiba.tuia.core.api.dto.advert.req.ReqAdvertHijackDto;

import java.util.Date;
import java.util.List;

/**
 * @author: wangjin
 * @create 2018-11-09 11:44
 **/
@AdvancedFeignClient
public interface RemoteAdvertHijackService {

    /**
     * 查询劫持数量
     * @param dto
     * @return
     */
    List<AdvertHijackDto> queryAdvertHijack(ReqAdvertHijackDto dto);

    /**
     * 根据选择日期和广告主ID删除
     * @param curDate
     * @param accountId
     * @return
     */
    int deleteByDateAndAccount(Date curDate, Long accountId);

    /**
     *  批量insert
     *
     * @param list
     * @return
     */
    int insetBatch(List<AdvertHijackDto> list);

}
