package cn.com.duiba.tuia.core.api.remoteservice.advertZeroStart;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advertZeroStart.AdvertZeroStartAbTestConfigDTO;
import cn.com.duiba.tuia.core.api.dto.advertZeroStart.AdvertZeroStartAbTestConfigFormDTO;
import cn.com.duiba.tuia.core.api.dto.advertZeroStart.AdvertZeroStartAbTestConfigQueryDTO;
import cn.com.duiba.tuia.core.api.dto.advertZeroStart.AdvertZeroStartTargetAppInfoDTO;

import java.util.List;

/**
 * 广告冷启动计划表 RemoteService
 * @author chencheng
 * @since 2022-12-13
 */
@AdvancedFeignClient
public interface RemoteAdvertZeroStartAbTestConfigService {

    AdvertZeroStartAbTestConfigDTO queryById(Long id);

    List<AdvertZeroStartAbTestConfigDTO> queryList(AdvertZeroStartAbTestConfigQueryDTO queryDTO);

    long queryCount(AdvertZeroStartAbTestConfigQueryDTO queryDTO);

    int save(AdvertZeroStartAbTestConfigFormDTO formDTO);

    /**
     * 查询冷启动配置对应的媒体信息
     *
     * @param advertId
     * @param orientPkgId
     * @return
     */
    AdvertZeroStartTargetAppInfoDTO queryTargetApp(Long advertId, Long orientPkgId);

}
