package cn.com.duiba.tuia.core.api.remoteservice.promotetest;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.abtest.AdvertPromoteTestBindAbtestDto;

import java.util.List;

/**
 * @author fanjia
 * @date 2021年07月07日 下午2:47
 */
@AdvancedFeignClient
public interface RemoteNewPromoteTestService {

    /**
     * 新增或修改落地页测试计划 默认状态是0关闭 需要手动设置开启状态  会同步到实验平台的
     *
     * @param advertPromoteTestDto
     * @return
     */
    Integer addOrUpdatePlan(AdvertPromoteTestBindAbtestDto advertPromoteTestDto) throws BizException;

    /**
     * 更新该广告的新落地页测试在实验平台的数据
     *
     * @param advertId 广告Id
     */
    public void updatePromoteABTestByAdvertId(Long advertId, Long creatorId);


    /**
     * 通过测试计划组id 删除测试计划组
     *
     * @param id 测试计划组的id
     * @return 结果
     */
    public int deleteAdvertPromoteTestBindAbtestGroupById(Long id);


    /**
     * 通过测试计划组id 删除测试计划组
     *
     * @param idList 测试计划组的id
     * @return 结果
     */
    public int deleteAdvertPromoteTestBindAbtestGroupByIdList(List<Long> idList);

    /**
     * 修改落地页测试计划的状态为停止
     *
     * @param id 落地页测试计划 计划ID
     * @return 结果
     */
    public int stopAdvertPromoteTestBindAbtestById(Long id) throws BizException;


    /**
     * 查询落地页测试计划 计划
     *
     * @param id 落地页测试计划 计划ID
     * @return 落地页测试计划 计划
     */
    public AdvertPromoteTestBindAbtestDto selectAdvertPromoteTestBindAbtestAndGroupById(Long id);


    /**
     * 更具广告id查询落地页测试计划
     *
     *
     * @param advertId          落地页测试计划 计划ID
     * @param enableState 启动状态 0关闭 1测试中 null 查询所有状态的
     * @return 落地页测试计划 计划
     */
    public List<AdvertPromoteTestBindAbtestDto> listAdvertPromoteTestBindAbtestAndGroupListByAdvertId(Long advertId, Integer enableState);


}
