package cn.com.duiba.tuia.core.api.utils;

import cn.com.duiba.tuia.core.api.execption.TuiaValidException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Objects;

/**
 * Created by zhangshun on 2020/2/11.
 */
public class AssertUtils {

    /**
     * Number 判断
     * @param string the object to check
     * @param message the exception message to use if the assertion fails
     * @throws TuiaManagerValidException if the object is {@code null}
     */
    public static void notNull(Number number, String message) {
        if (Objects.isNull(number)) {
            throw new TuiaValidException(message);
        }
    }

    /**
     * String 判断
     * @param string the object to check
     * @param message the exception message to use if the assertion fails
     * @throws TuiaManagerValidException if the object is {@code null}
     */
    public static void notBlank(String string, String message) {
        if (StringUtils.isBlank(string)) {
            throw new TuiaValidException(message);
        }
    }

    /**
     * 集合判断
     * @param collection the object to check
     * @param message the exception message to use if the assertion fails
     * @throws TuiaManagerValidException if the object is {@code null}
     */
    public static void notEmpty(Collection collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new TuiaValidException(message);
        }
    }

    /**
     * 集合判断
     * @param object the object to check
     * @param message the exception message to use if the assertion fails
     * @throws TuiaManagerValidException if the object is {@code null}
     */
    public static void notNullAsObject(Object object, String message) {
        if (null == object) {
            throw new TuiaValidException(message);
        }
    }
}
