package cn.com.duiba.tuia.core.api.dto.jfsite;

import java.io.Serializable;
import java.util.Date;


/**
 * 积木弹层数据回流详情表
 */
public class AdvertStatisticsLayerDetailDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 弹层id
     */
    private Long layerId;

    /**
     * 组件id
     */
    private String cnameId;

    /**
     * 1 跳转链接 , 2 跳转链接-帧 , 3 跳转场景-场景2 , 4 跳转场景-帧 , 5 普通事件 , 6 帧事件
     */
    private String jumpType;

    /**
     * jump_type为 2,4,6 时对应的帧
     */
    private Integer frame;

    /**
     * jump_type为3时场景的id
     */
    private String sceneId;

    /**
     * 事件码
     */
    private String eventsCode;

    /**
     * 总pv
     */
    private Long totalPv;

    /**
     * 总uv
     */
    private Long totalUv;

    /**
     * 记录时间
     */
    private Date curDate;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setLayerId(Long layerId) {
        this.layerId = layerId;
    }

    public Long getLayerId() {
        return layerId;
    }

    public void setCnameId(String cnameId) {
        this.cnameId = cnameId;
    }

    public String getCnameId() {
        return cnameId;
    }

    public void setJumpType(String jumpType) {
        this.jumpType = jumpType;
    }

    public String getJumpType() {
        return jumpType;
    }

    public void setFrame(Integer frame) {
        this.frame = frame;
    }

    public Integer getFrame() {
        return frame;
    }

    public void setSceneId(String sceneId) {
        this.sceneId = sceneId;
    }

    public String getSceneId() {
        return sceneId;
    }

    public void setEventsCode(String eventsCode) {
        this.eventsCode = eventsCode;
    }

    public String getEventsCode() {
        return eventsCode;
    }

    public void setTotalPv(Long totalPv) {
        this.totalPv = totalPv;
    }

    public Long getTotalPv() {
        return totalPv;
    }

    public void setTotalUv(Long totalUv) {
        this.totalUv = totalUv;
    }

    public Long getTotalUv() {
        return totalUv;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }
}
