package cn.com.duiba.tuia.core.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * 转换目标和字段的映射
 * 为了解决根据subType的数字类型获取对应的转化目标的数值问题
 *
 * @author Wangpf
 * @date 2022/12/27 5:06 下午
 */
@Getter
public enum SubTypeReflectEnum {

    /**
     * 落地页转化
     */
    CVR(0, "effectPv", "落地页转化"),
    /**
     * 安装
     */
    INSTALL(1, "installPv", "安装"),
    /**
     * 启动
     */
    START(2, "startPv", "激活(启动)"),
    /**
     * 注册
     */
    REGISTER(3, "registePv", "注册"),
    /**
     * 激活
     */
    ACTIVITY(4, "activatePv", "激活"),
    /**
     * 登录
     */
    LOGIN(5, "loginPv", "登录"),
    /**
     * 付费
     */
    PAY(6, "payPv", "付费"),
    /**
     * 进件
     */
    ENTRY(7, "entryPv", "进件"),
    /**
     * 完件
     */
    FINISH(8, "finishPv", "完件"),
    /**
     * 签收
     */
    SIGN_FOR(9, "signPv", "签收"),
    /**
     * 留存
     */
    DENY(10, "denyPv", "留存"),

    /**
     * 出单
     */
    OUT_ORDER(11, "orderCnt", "出单"),
    ;

    /**
     * 转化目标
     */
    private final Integer subtype;

    /**
     * 对应的字段 {@link cn.com.duiba.tuia.core.api.dto.advertZeroStart.AdvertZeroStartTransformDayConfigCommonDTO}
     */
    private final String filed;

    /**
     * 描述
     */
    private final String desc;

    SubTypeReflectEnum(Integer subtype, String filed, String desc) {
        this.subtype = subtype;
        this.filed = filed;
        this.desc = desc;
    }

    public static String getFiledBySubType(Integer subtype) {
        for (SubTypeReflectEnum reflectEnum : SubTypeReflectEnum.values()) {
            if (Objects.equals(reflectEnum.getSubtype(), subtype)) {
                return reflectEnum.getFiled();
            }
        }
        return null;
    }
}
