package cn.com.duiba.tuia.core.api.enums.statistics;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 
 * ClassName: AdvertTransformTitleEnum <br/>
 * Function: 广告转化数据的标题. <br/>
 * date: 2018年4月20日 下午2:14:37 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AdvertTransformTitleEnum {

    /** 安装PV */
    INSTALL_PV("installPv", "安装PV"),
    
    /** 安装UV */
    INSTALL_UV("installUv", "安装UV"),
    
    /** 安装PV/UV */
    INSTALL_PV_UV("installPvUv", "安装PV/UV"),
    
    /** 安装成本 */
    INSTALL_COST("installCost", "安装成本（PV）"),
    
    /** APP启动PV */
    START_PV("startPv", "APP启动PV"),
    
    /** APP启动UV */
    START_UV("startUv", "APP启动UV"),
    
    /** APP启动PV/UV */
    START_PV_UV("startPvUv", "APP启动PV/UV"),
    
    /** APP启动成本 */
    START_COST("startCost", "APP启动成本（PV）"),

    /** 启动CVR */
    START_CVR("startCvr", "启动CVR"),
    
    /** 注册PV */
    REGISTE_PV("registePv", "注册PV"),
    
    /** 注册UV */
    REGISTE_UV("registeUv", "注册UV"),
    
    /** 注册PV/UV */
    REGISTE_PV_UV("registePvUv", "注册PV/UV"),
    
    /** 注册成本 */
    REGISTE_COST("registeCost", "注册成本（PV）"),

    /** 注册CVR */
    REGISTE_CVR("registeCvr", "注册CVR"),
    
    /** 激活PV */
    ACTIVATE_PV("activatePv", "激活PV"),
    
    /** 激活UV */
    ACTIVATE_UV("activateUv", "激活UV"),
    
    /** 激活PV/UV */
    ACTIVATE_PV_UV("activatePvUv", "激活PV/UV"),
    
    /** 激活成本 */
    ACTIVATE_COST("activateCost", "激活成本（PV）"),
    
    /** 登录PV */
    LOGIN_PV("loginPv", "登录PV"),
    
    /** 登录UV */
    LOGIN_UV("loginUv", "登录UV"),
    
    /** 登录PV/UV */
    LOGIN_PV_UV("loginPvUv", "登录PV/UV"),
    
    /** 登录成本 */
    LOGIN_COST("loginCost", "登录成本（PV）"),
    
    /** 付费PV */
    PAY_PV("payPv", "付费PV"),
    
    /** 付费UV */
    PAY_UV("payUv", "付费UV"),
    
    /** 付费PV/UV */
    PAY_PV_UV("payPvUv", "付费PV/UV"),
    
    /** 付费成本 */
    PAY_COST("payCost", "付费成本（PV）"),
    
    /** 进件PV */
    ENTRY_PV("entryPv", "进件PV"),
    
    /** 进件UV */
    ENTRY_UV("entryUv", "进件UV"),
    
    /** 进件PV/UV */
    ENTRY_PV_UV("entryPvUv", "进件PV/UV"),
    
    /** 进件成本 */
    ENTRY_COST("entryCost", "进件成本（PV）"),
    
    /** 完件PV */
    FINISH_PV("finishPv", "完件PV"),
    
    /** 完件UV */
    FINISH_UV("finishUv", "完件UV"),
    
    /** 完件PV/UV */
    FINISH_PV_UV("finishPvUv", "完件PV/UV"),
    
    /** 完件成本 */
    FINISH_COST("finishCost", "完件成本（PV）"),

    /** 用户签收PV */
    SIGN_PV("signPv", "用户签收PV"),

    /** 用户签收UV */
    SIGN_UV("signUv", "用户签收UV"),

    /** 用户签收PV/UV */
    SIGN_PV_UV("signPvUv", "签收PV/UV"),

    /** 签收成本 */
    SIGN_COST("signCost", "签收成本（PV）"),

    /** 用户拒签PV */
    DENY_PV("denyPv", "用户拒签PV"),

    /** 用户拒签UV */
    DENY_UV("denyUv", "用户拒签UV"),

    /** 用户拒签PV/UV */
    DENY_PV_UV("denyPvUv", "拒签PV/UV"),

    /** 拒签成本 */
    DENY_COST("denyCost", "拒签成本（PV）"),

    /**有效订单pv/uv*/
    EFFECT_ORDER_PV_UV("effectOrderPvUv", "有效订单pv/uv"),

    /**有效订单数成本*/
    EFFECT_ORDER_COST("effectOrderCost", "有效订单成本"),

    /**付费金额**/
    PAYMENT_AMOUNT("paymentAmount", "付费金额"),

    /**roi**/
    ROI("roi", "投放roi"),

    ;


    private String desc;

    private String code;

    AdvertTransformTitleEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, AdvertTransformTitleEnum> enumMap = Maps.newHashMap();
    static {
        for (AdvertTransformTitleEnum it : AdvertTransformTitleEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AdvertTransformTitleEnum getByCode(String code) {
        return enumMap.get(code);
    }
}
