package cn.com.duiba.tuia.core.api.param;

import cn.com.duiba.tuia.core.api.enums.reflow.ReflowPlanStatusEnum;
import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;
import lombok.Data;

import java.util.List;

/**
 * @author Wangpf
 * @description  媒体自动回流计划查询参数
 * @date 2021/11/19 10:42 上午
 */
@Data
public class AppAutoReflowPlanParam extends BaseQueryReq {

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 推啊广告ID
     */
    private Long advertId;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 计划状态
     *
     * {@link ReflowPlanStatusEnum}
     */
    private Integer planStatus;

    /**
     * 广告主对应的广告Id
     */
    private List<Long> advertIdsByAdvertiserName;

    /**
     * 广告对应的广告Id
     */
    private List<Long> advertIdsByAdvertName;

    /**
     * 广告名称
     */
    private String advertName;
}
