package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PotentionalAdvertDto;
import cn.com.duiba.tuia.core.api.dto.advert.OrientationFocusAppConvertCostDto;

import java.util.List;

/**
 * @author zhangmeng
 * @date 2019/4/17
 * @function 潜力广告测试
 */
@AdvancedFeignClient
public interface RemotePotentionalAdvertService {

    /**
     * 获取所有的潜力广告
     */
    List<PotentionalAdvertDto> getAllPotionalAdvert()throws BizException;

    /**
     * 新增潜力广告
     */
    Boolean addPotionalAdvert(List<PotentionalAdvertDto> potentionalAdvertDtos)throws BizException;


    /**
     * 删除潜力广告
     */
    Boolean deletePotionalAdvert(List<Long> ids)throws BizException;

    /**
     * 删除潜力广告前校验
     */
    Boolean deletePotentionalCheck(Long advertId)throws BizException;

    /**
     * 修改潜力广告
     */
    Boolean updatePotentionalAdvert(List<PotentionalAdvertDto> potentionalAdvertDtos)throws BizException;

    /**
     * 通过广告id查询数据
     */
    Boolean getPotentionalAdvertByAdvertId(Long advertId);

    /**
     * 重新开启潜力广告测试
     */
    void reOpenPotentionalAdvert(Long advertId,Long orientPkgId);

    /**
     * 关闭潜力广告测试
     */
    void closePotentionalAdvert(Long advertId, Long orientPkgId);

    /**
     * 增删改 潜力广告
     */
    void crudPotentionalAdvert(List<OrientationFocusAppConvertCostDto> list);
}
