package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * Created by MichealWang on 2018/9/7 0007.
 */
@ApiModel("广告-定向配置分时统计请求参数")
public class QueryPackageDataByHourReq extends ByDateQueryReq {

    /** The advert id. */
    @ApiModelProperty(value = "广告ID",hidden = true)
    private Long   advertId;

    /** 广告名称. */
    @ApiModelProperty("广告名称")
    private String advertName;

    @ApiModelProperty("配置名称")
    private String           packageName;

    @ApiModelProperty("配置Id")
    @NotNull(message = "配置ID不能为空")
    private Long           packageId;

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Long getPackageId() {
        return packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }
}
