package cn.com.duiba.tuia.core.api.dto.advert;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 广告扶持配置表
 * @author lijicong
 * @since 2021-02-25
 */
@Getter
@Setter
public class AdvertSupportConfigFormDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("")
    private Long id;

    @ApiModelProperty("综合行业名称(新行业)")
    private String newTrade;

    @ApiModelProperty("每日单媒体上限，-1不限")
    private Integer upperDayMedia;

    @ApiModelProperty("总扶持发券上限，-1不限")
    private Integer upperDaySum;

    @ApiModelProperty("出价扶持低值")
    private BigDecimal priceStart;

    @ApiModelProperty("出价扶持高值")
    private BigDecimal priceEnd;

}