package cn.com.duiba.tuia.core.api.dto.land;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Wangpf
 * @description
 * @date 2019/7/23 21:08
 */
public class LandPageDiagnosisResultDto implements Serializable {

    private static final long serialVersionUID = -3692505878797723586L;
    /**
     * 页面ID
     */
    private long pageId;

    /**
     * 广告ID
     */
    private long advertId;

    /**
     *  广告名称
     */
    private String advertName;

    /**
     * 落地页链接
     */
    private String url;

    /**
     * 加载时间
     */
    private BigDecimal loadTime;


    /**
     * 当前页面大小
     */
    private BigDecimal size;

    /**
     * 诊断时间
     */
    private Date diagnosisTime;

    public LandPageDiagnosisResultDto() {
    }

    public LandPageDiagnosisResultDto(long pageId, long advertId, String advertName, String url, BigDecimal loadTime, BigDecimal size, Date diagnosisTime) {
        this.pageId = pageId;
        this.advertId = advertId;
        this.advertName = advertName;
        this.url = url;
        this.loadTime = loadTime;
        this.size = size;
        this.diagnosisTime = diagnosisTime;
    }

    public long getPageId() {
        return pageId;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public BigDecimal getLoadTime() {
        return loadTime;
    }

    public void setLoadTime(BigDecimal loadTime) {
        this.loadTime = loadTime;
    }

    public BigDecimal getSize() {
        return size;
    }

    public void setSize(BigDecimal size) {
        this.size = size;
    }

    public Date getDiagnosisTime() {
        return diagnosisTime;
    }

    public void setDiagnosisTime(Date diagnosisTime) {
        this.diagnosisTime = diagnosisTime;
    }
}
