package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AppArpuDto;
import cn.com.duiba.tuia.core.api.dto.app.ReqPageQueryAppDataDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteAppArpuService {

    /**
     * 分页查询所有的应用arpu值
     * @param dto
     * @return
     */
    Map<Long, Double> selectAllArpu(ReqPageQueryAppDataDto dto);

    /**
     * 根据appIds,批量获取应用arpu值
     * @param dto
     * @return
     */
    Map<Long, Double> selectAppArpu(ReqPageQueryAppDataDto dto);

    /**
     * 根据appIds,查询应用arpu值
     * @param appIds
     * @return
     */
    Map<Long, Double> selectAppArpuByAppIds(List<Long> appIds);

    /**
     * 统计有应用arpu个数
     * @return
     */
    Long countAppArpu(ReqPageQueryAppDataDto dto);

    /**
     * 批量增加app的arpu
     * @param appArpuDOS
     * @return
     */
    Integer insertAppArpu(List<AppArpuDto> appArpuDOS);

    /**
     * 批量修改应用arpu值
     * @param appIds
     * @param arpu
     */
    void updateAppArpu(List<Long> appIds, Double arpu);

    /**
     * 移除应用arpu值
     * @param appIds
     * @return
     */
    Integer deleteAppArpu(List<Long> appIds);
}
