package cn.com.duiba.tuia.core.api.remoteservice.earnestMoney;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.EmployeeDto;
import cn.com.duiba.tuia.core.api.dto.earnestMoney.EarnestMoneyDto;
import cn.com.duiba.tuia.core.api.dto.earnestMoney.EarnestMoneyQueryDto;
import cn.com.duiba.tuia.core.api.dto.earnestMoney.EarnestMoneyRechargeRecordDto;
import cn.com.duiba.tuia.core.api.dto.earnestMoney.EarnestMoneyRechargeRecordQueryDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteEarnestMoneyService {
    /**
     * 充值后的保证金
     * @param queryDto
     * @return
     */
    Long getTotalAmount(EarnestMoneyRechargeRecordQueryDto queryDto);

    /**
     * 查询保证金记录
     * @param queryDto
     * @return
     */
    List<EarnestMoneyRechargeRecordDto> rechargeRecordList(EarnestMoneyRechargeRecordQueryDto queryDto);

    /**
     * 查询保证金余额（不区分类型）
     *
     * @param accountIds 账号id列表
     * @return 保证金余额列表
     */
    List<EarnestMoneyDto> listByAccountIds(List<Long> accountIds);

    /**
     * 查询保证金余额（区分类型）
     *
     * @param accountIds 账号id列表
     * @return 保证金余额列表
     */
    List<EarnestMoneyDto> listDetailByAccountIds(List<Long> accountIds);

    /**
     * 总数
     * @param queryDto
     * @return
     */
    Integer rechargeRecordCount(EarnestMoneyRechargeRecordQueryDto queryDto);

    /**
     * 查找账户充值后对应的保证金
     * @param queryDto
     * @return
     */
    Map<Long, Long> getAmount(EarnestMoneyRechargeRecordQueryDto queryDto);
}
