package cn.com.duiba.tuia.core.api.remoteservice.logback;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.logback.AdvertLogBackRuleDto;
import cn.com.duiba.tuia.core.api.dto.req.logback.AdvertLogBackRuleReq;
import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;

/**
 * 广告主日志回流规范相关服务
 */
@AdvancedFeignClient
public interface RemoteAdvertLogBackRuleService {
   /**
    * 查询回传规范列表
    * @param queryReq
    * @return
    */
   PageDto<AdvertLogBackRuleDto> pageQuery(BaseQueryReq queryReq) throws BizException;

   /**
    * 保存
    * @param dataBackReq
    * @return
    */
   Boolean save(AdvertLogBackRuleReq dataBackReq) throws BizException;

   /**
    * 修改
    * @param dataBackReq
    */
   Boolean edit(AdvertLogBackRuleReq dataBackReq) throws BizException;


   /**
    * 删除
    * @param id
    * @return
    */
   Boolean delete(Long id);

}
