package cn.com.duiba.tuia.core.api.remoteservice.slot;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.core.api.dto.advert.SlotCheatFlowConsumeDto;
import cn.com.duiba.tuia.core.api.dto.advert.SlotCheatFlowGradeDto;

import java.util.Date;
import java.util.List;

/**
 * Created by huangch on 2018/5/18 14:20
 * description:
 *
 * @since JDK 1.6
 */
@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "600000")
@AdvancedFeignClient
public interface RemoteSlotCheatFlowService {

    /**
     * 获取广告作弊流量消耗
     *
     * @param advertIds 广告ID
     * @param startDate 查询开始日期
     * @param endDate   查询结束日期
     */
    List<SlotCheatFlowConsumeDto> getAdvertCheatFlowConsumeList(List<Long> advertIds, Date startDate, Date endDate, Integer exportType, Integer activityType);

    /**
     * 查询媒体作弊流量消耗
     */
    List<SlotCheatFlowConsumeDto> getAppCheatFlowConsumeList(List<Long> appIds, Long advertId, Date startDate, Date endDate, Integer exportType, Integer activityType);

    /**
     * 查询广告位作弊流量消耗
     */
    List<SlotCheatFlowConsumeDto> getSlotCheatFlowConsumeList(List<Long> slotIds, Long advertId, Date startDate, Date endDate, Integer exportType, Integer activityType);

    /**
     * 获取广告位作弊流量诊断结果
     *
     * @param slotIds 诊断广告位id
     * @return 广告位诊断结果
     */
    List<SlotCheatFlowGradeDto> getSlotCheatFlowGradeList(List<Long> slotIds);
}
