/**
 * 文件名： GetAdvertMaterialStatisticsReq.java<br>
 * 此类描述的是：<br>
 * 作者: zufengze<br>
 * 创建时间: 2016年4月1日 下午1:53:11
 */
package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModel;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseQueryDateReq;

/**
 * ClassName: GetAdvertMaterialStatisticsReq <br/>
 * Function: 分页模糊查询广告素材统计数据参数. <br/>
 * date: 2017年9月6日 上午10:33:12 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
@ApiModel("分页模糊查询广告素材统计数据参数")
public class GetAdvertMaterialStatisticsReq extends BaseQueryDateReq {

    private static final long serialVersionUID = 1993376949393405526L;

    /** 素材ID. */
    private List<Long>        materialIds;

    /** 广告ID. */
    private List<Long>        advertIds;

    /** 0 or null ：汇总，1：分日 */
    private Integer           exportType;

    /** 活动类型：0-互动广告，1-展示广告 */
    private Integer           activityType;

    /** 排除的素材ID集合. */
    private List<Long> excludeMaterialIds;

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * exportType.
     *
     * @return the exportType
     * @since JDK 1.8
     */
    public Integer getExportType() {
        return exportType;
    }

    /**
     * exportType.
     *
     * @param exportType the exportType to set
     * @since JDK 1.8
     */
    public void setExportType(Integer exportType) {
        this.exportType = exportType;
    }

    /**
     * materialIds.
     *
     * @return the materialIds
     * @since JDK 1.8
     */
    public List<Long> getMaterialIds() {
        return materialIds;
    }

    /**
     * materialIds.
     *
     * @param materialIds the materialIds to set
     * @since JDK 1.8
     */
    public void setMaterialIds(List<Long> materialIds) {
        this.materialIds = materialIds;
    }

    /**
     * advertIds.
     *
     * @return the advertIds
     * @since JDK 1.8
     */
    public List<Long> getAdvertIds() {
        return advertIds;
    }

    /**
     * advertIds.
     *
     * @param advertIds the advertIds to set
     * @since JDK 1.8
     */
    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    public List<Long> getExcludeMaterialIds() {
        return excludeMaterialIds;
    }

    public void setExcludeMaterialIds(List<Long> excludeMaterialIds) {
        this.excludeMaterialIds = excludeMaterialIds;
    }

    /**
     * To string.
     *
     * @return the string
     * @see Object#toString()
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
