package cn.com.duiba.tuia.core.api.constant;

/**
 * API对接方式枚举类
 * @author zhongda & ikongyi
 */
public enum RtaApiConnectionType {
    /**
     * 媒体作为平台方，推啊按照媒体提供的API文档进行对接
     */
    MANUAL(0, "人工对接"),
    /**
     * 推啊作为平台方，媒体按照推啊提供的API文档进行对接
     */
    AUTO(1, "自动对接")
    ;

    private Integer type;
    private String desc;

    RtaApiConnectionType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
