package cn.com.duiba.tuia.core.api.dto.compensate;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 广告配置新赔付DTO
 *
 * @author zhangbaiqiang
 * @date 2021/1/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CompensateNewPackageDTO extends BaseDto implements Serializable {
    private static final long serialVersionUID = -2676751113181752002L;

    /**
     * 赔付日期
     */
    private Date compensateDate;

    /**
     * 计划id
     */
    private Long advertId;

    /**
     * 配置id
     */
    private Long pkgId;

    /**
     * 是否新计划
     */
    private Integer isNew;

    /**
     * 赔付金额
     */
    private Integer compensateAmount;

    /**
     * 转化数
     */
    private Integer transferPv;

    /**
     * 目标成本
     */
    private Integer targetCost;

    /**
     * 转化成本
     */
    private Integer transferCost;

    /**
     * 目标消耗
     */
    private Integer targetConsume;

    /**
     * 实际消耗
     */
    private Integer transferConsume;

    /**
     * 成本异常百分比：(转化成本-目标成本)/目标成本
     * 注意：前端展示是80%，存的值则是8000，所以传给前端前要除以100
     */
    private Integer expRate;
}
