package cn.com.duiba.tuia.core.api.dto.media.response;

import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhangmeng
 * @date 2019/6/26
 * @function
 */
@Data
public class RspMediaSlotPackageWhiteDto implements Serializable {

    private static final long serialVersionUID = 1L;


    private Long id;

    private Long advertId;

    private String advertName;

    private Long accountId;

    private String accountName;

    /**
     * 行业标签
     */
    private List<String> industryTags;

    /**
     * 属性标签
     */
    private List<String> advertTags;

    /** 资源标签 */
    private List<String> resourceTags;

    /**
     * 落地页标签
     */
    private List<String> promoteTags;

    /**
     * 有效状态
     * 0 - 无效状态，1-有效 ，2-无效（暂停），3-无效（审核中），4-无效（审核拒绝），5-无效（账号余额不足）
     * 6-无效（账号预算不足），7-无效（广告预算不足），8-无效（库存不足），9-无效（非投放日期），10-无效（优惠码失效），11-无效（落地页审核被拒绝）
     */
    private Integer validateStatus;

    /**
     * 无效原因
     */
    private String validateReason;

    /**
     *是否已在当前广告位的屏蔽名单中
     * 0-否，1-是 ，2-白名单中已经存在，无法添加
     */
    private Integer shiedStatus;
}
