package cn.com.duiba.tuia.core.api.dto.req.reflow;

import cn.com.duiba.tuia.core.api.enums.reflow.ReflowPlanStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 媒体自动回流计划表
*/
@Data
public class AppAutoReflowPlanDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 
    */
    private Long id;

    /**
    * 计划Id，用uuid来代替避免冲突
    */
    private String planId;

    /**
    * 回流计划有效开始时间
    */
    private String effectiveStartTime;

    /**
    * 回流计划有效结束时间
    */
    private String effectiveEndTime;

    /**
    * 回流模式 ByCpc→ 按照点击回流 ByCpA→ 按照转化回流
    */
    private String reflowMode;

    /**
    * 外部媒体名称
    */
    private String externalAppName;

    /**
    * 外部媒体账号ID,比如快手，巨量等
    */
    private String externalAppAccountId;

    /**
    * 外部广告计划ID,逗号分隔的字符串
    */
    private String externalAdvertIdStr;

    /**
    * 推啊广告ID
    */
    private Long advertId;

    /**
    * 推啊媒体ID
    */
    private Long appId;

    /**
    * 推啊媒体appKey
    */
    private String appKey;

    /**
    * 推啊广告位ID
    */
    private Long slotId;

    /**
    * 刷量比例 比如 30
    */
    private Integer brushRatio;

    /**
    * Ctr基准线
    */
    private Integer ctrFiducialValue;

    /**
    * 计划开关状态 1-开 0-关闭
    */
    private Integer switchStatus;

    /**
    * 是否删除 1-已删除 0未删除
    */
    private Integer isDeleted;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 广告名称
     */
    private String advertName;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 回流计划状态
     *
     * {@link ReflowPlanStatusEnum}
     */
    private Integer planStatus;
}

