package cn.com.duiba.tuia.core.api.dto.slot;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 券次序定制广告配置DTO
 *
 * @author zhangbaiqiang
 * @date 2021/6/9
 */
@Data
public class OrderCustomConfigDto implements Serializable {
    private static final long serialVersionUID = -6817733815975752688L;

    /**
     * 配置Id
     */
    private Long id;

    /**
     * 广告位Id
     */
    private Long slotId;

    /**
     * 发券次序
     */
    private Integer order;

    /**
     * 维度
     * {@link cn.com.duiba.tuia.core.api.enums.slot.OrderCustomDimEnum}
     */
    private Integer dim;

    /**
     * 值
     */
    private String value;

    /**
     * 操作人Id
     */
    private Long operatorId;

    /**
     * 操作人名称
     */
    private String operatorName;

    /**
     * 操作时间
     */
    private Date gmtModified;

    /**
     * 值和比例构建的字符串
     */
    private String customValueRatio;
}
