package cn.com.duiba.tuia.core.api.enums.advert;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: AdvertValidStatusEnum <br/>
 * Function: 广告计费方式. <br/>
 * date: 2017年8月22日 下午7:11:05 <br/>
 *
 * @author chencheng
 * @version
 */
public enum AdvertFeeTypeEnum {

    /** CPC方式 */
    CPC(1, "CPC"),

    /** CPA方式. */
    CPA(2, "CPA");

    private String  desc;

    private Integer code;

    AdvertFeeTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, AdvertFeeTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AdvertFeeTypeEnum it : AdvertFeeTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AdvertFeeTypeEnum getByName(Integer code) {
        return enumMap.get(code);
    }
}
