package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertStatisticsMonitorDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertStatisticsReportDto;
import cn.com.duiba.tuia.core.api.param.AdvertStatisticsReportParam;

import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/7/31.
 */
@AdvancedFeignClient
public interface RemoteAdvertStatisticsReportService {

    /**
     * 分页查询数量
     * @param param
     * @return
     */
    Long countAccountByParam(AdvertStatisticsReportParam param);

    /**
     * 分页查询数据
     * @param param
     * @return
     */
    List<AdvertStatisticsReportDto> findAccountByParam(AdvertStatisticsReportParam param);

    /**
     * 分页查询数量
     * @param param
     * @return
     */
    Long countAdvertByParam(AdvertStatisticsReportParam param);

    /**
     * 分页查询数据
     * @param param
     * @return
     */
    List<AdvertStatisticsReportDto> findAdvertByParam(AdvertStatisticsReportParam param);

    /**
     * 查询匹配率异常的广告主
     * @param param
     * @return
     */
    List<AdvertStatisticsMonitorDto> findAdvertsByMonitor(Map<String,String> param);
}
