package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.app.AdvertCollectAppDto;
import cn.com.duiba.tuia.core.api.dto.app.CollectAppDto;
import cn.com.duiba.tuia.core.api.dto.app.CollectAppReq;
import cn.com.duiba.tuia.core.api.dto.app.CollectAppRuleReq;
import cn.com.duiba.tuia.core.api.dto.statistics.CollectAppBasicInfoDto;

import java.util.List;

/**
 *
 */
@AdvancedFeignClient
public interface RemoteAdvertCollectAppService {
    /**
     * 根据广告ID查询关联的聚合媒体信息
     *
     * @param advertId
     * @return
     */
    List<CollectAppDto> getAdvertCollectAppInfoByAdvertIds(Long advertId);

    /**
     * 根据配置ID查询关联的聚合媒体信息
     *
     * @param opkId
     * @return
     */
    List<CollectAppDto> getAdvertCollectAppInfoByOpkIds(Long opkId);

    /**
     * 批量保存定向聚合媒体包
     * @param list
     * @return
     */
    Integer batchSave(List<AdvertCollectAppDto> list);

    /**
     * 根据配置定向聚合媒体的id 删除定向数据
     * @param ids
     * @return
     */
    Integer deleteBatchById(List<Long> ids);

    /**
     * 根据条件查询定向的聚合媒体
     * @param params
     * @return
     */
    List<AdvertCollectAppDto> listByParam(AdvertCollectAppDto params);

}
